// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.io;

import ORG.oclc.oai.harvester.verb.Header;
import java.util.List;
import ORG.oclc.oai.harvester.verb.ListIdentifiers;
import ORG.oclc.oai.harvester.verb.OAIError;
import java.io.IOException;
import org.xml.sax.SAXException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.net.URL;

public class ListIdentifiersReader
{
    private URL baseURL;
    private String resumptionToken;
    private Iterator headers;
    
    public ListIdentifiersReader(final URL baseURL, final String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this(baseURL, null, null, null, metadataPrefix);
    }
    
    public ListIdentifiersReader(final URL baseURL, final String from, final String until, final String set, final String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this.resumptionToken = null;
        this.headers = null;
        this.baseURL = baseURL;
        final ListIdentifiers listIdentifiers = new ListIdentifiers(baseURL, from, until, set, metadataPrefix);
        if (listIdentifiers != null) {
            final List errors = listIdentifiers.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.headers = listIdentifiers.iterator();
            this.resumptionToken = listIdentifiers.getResumptionToken();
        }
    }
    
    public Header readNext() throws MalformedURLException, SAXException, IOException, OAIError {
        while (this.headers != null && !this.headers.hasNext()) {
            if (this.resumptionToken == null) {
                return null;
            }
            final ListIdentifiers listIdentifiers = new ListIdentifiers(this.baseURL, this.resumptionToken);
            if (listIdentifiers == null) {
                return null;
            }
            final List errors = listIdentifiers.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.headers = listIdentifiers.iterator();
            this.resumptionToken = listIdentifiers.getResumptionToken();
        }
        if (this.headers == null) {
            return null;
        }
        return this.headers.next();
    }
    
    public void close() {
    }
}
